Attribute VB_Name = "mdCenterAxes"
'       This is a part of the source code for Pro/DESKTOP.
'       Copyright (C) 1999-2002 Parametric Technology Corporation.
'       All rights reserved.


Function CenterAxes(firstGeometric As aGeometric, secondGeometric As aGeometric)

'Convenince Function to make two circular edges, cylindrical faces or circular lines co-axial

'Check if the entitied are selected and
'if the selected entities belong to GeometricClass

If firstGeometric Is Nothing Then
    MsgBox ("Entity not Selected")
    Exit Function
End If

If secondGeometric Is Nothing Then
    MsgBox ("Entity not Selected")
    Exit Function
End If

'Get the ProDESKTOP Application object
GetApplicationObject
    
'Get the active partDocument
Dim Part As PartDocument
Set Part = app.GetActiveDoc
    
'UpdateDependencies method
If (secondGeometric.IsDependentOn(firstGeometric)) Then
    Set temp = firstGeometric
    Set firstGeometric = secondGeometric
    Set secondGeometric = temp
End If
'end UpdateDependencies
    
Dim ins As aDesignInstance
Set ins = firstGeometric.GetParent("DesignInstance")
       
Dim mc As zMatingCondition
     
If ((firstGeometric.GetGeometricForm.IsA("Circle") And secondGeometric.GetGeometricForm.IsA("Circle")) Or (firstGeometric.GetGeometricForm.IsA("Cylinder") And secondGeometric.GetGeometricForm.IsA("Cylinder"))) Then
    'Create Align to make the circular entities co-axial
    Set mc = app.GetClass("CenterAxes").CreateCenterAxes2(firstGeometric, secondGeometric)
Else
    MsgBox "The Selected Entities are not Circular/Cylindrical"
    Exit Function
End If

ins.AddMatingCondition mc
    
End Function
